/* ============ */
/* pokrdefs.h	*/
/* ============ */
/* ==================================================================== */
/*	   TYPEDEFS AND DEFINED MACROS FOR POKER-TEST FUNCTIONS		*/
/* ==================================================================== */
# if defined(__RUNSDEFS_H__)
#		/* Do Nothing. */
# else
#	define	__RUNSDEFS_H__
# if !defined(__DEFCODES)

typedef	unsigned char		UCHAR;
typedef	unsigned int		UINT;
typedef	unsigned long		ULONG;

#define	FALSE	0
#define	TRUE	1
# endif

#define	MAX_CARDS	  8
#define	MIN_CARDS	  4
#define MAX_CELL_XPCT	 10
#define MIN_CELL_XPCT	  5
#define	MAX_DECK_SIZE	128
#define	MIN_DECK_SIZE	 10


/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
# undef F
# if defined(__STDC__) || defined(__PROTO__)
#	define  F( P )  P
# else
#	define  F( P )  ()
# endif

/* INDENT OFF */

typedef	struct	PokerDataStru
    {
	long	NumHands;               /* Number of Hands to be Dealt	*/
	int	CardsPerHand;		/* Number of Cards in Each Hand	*/
	int	DataSize;		/* Number of Variates in Range	*/
	long	TotNumGen;		/* Accumulated Variate Count	*/
	int	UserCellExpect;		/* User-Minimum Cell Expectation*/
	double	CellExpect[MAX_CARDS];	/* Calculated Cell Expectations	*/
	ULONG	UserNumHands;		/* # Needed for UserCellExpect	*/
	ULONG	IdealNumHands;		/* # Needed for MIN_CELL_XPCT	*/
	int	NotEnough;		/* # Categories < UserCellExpect*/
	int	CallStatusOK;		/* 0 = False, 1 = True		*/
	double	PokerChiSq;		/* Poker-Run Chi-Square Data	*/
	int	(*RandFun) F((void));	/* Addr. of Generating Function	*/
    }
    POKER_DATA_STRU;

extern	void	CalcPokerChiSq F((struct PokerDataStru *));
extern	void	CalcPokerProbs F((int, int, double *));
extern	void	GenPokerData F((struct PokerDataStru *));
extern	void	SetPokerControls F((struct PokerDataStru *));

# undef F
/* INDENT ON */
# endif		/* << __RUNSDEFS_H__ >>	*/
